/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.mixin;

import com.mojang.authlib.GameProfile;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657
implements LivingEntityMixed {
    @Unique
    private final LinkedList<Card> charta_hand = new LinkedList();
    @Unique
    private CompletableFuture<CardPlay> charta_play = new CompletableFuture();
    @Unique
    private final CardPlayer charta_cardPlayer = new CardPlayer(){

        @Override
        public LinkedList<Card> hand() {
            return ServerPlayerMixin.this.charta_hand;
        }

        @Override
        public void play(CardPlay play) {
            ServerPlayerMixin.this.charta_play.complete(play);
        }

        @Override
        public void afterPlay(Consumer<CardPlay> consumer) {
            ServerPlayerMixin.this.charta_play.thenAccept(play -> {
                try {
                    consumer.accept((CardPlay)play);
                }
                catch (Exception e) {
                    Charta.LOGGER.error("Error while handling {}'s Card Play. ", (Object)this.getName().getString(), (Object)e);
                }
            });
        }

        @Override
        public void resetPlay() {
            ServerPlayerMixin.this.charta_play = new CompletableFuture();
        }

        @Override
        public void tick(CardGame<?> game) {
        }

        @Override
        public boolean shouldCompute() {
            return false;
        }

        @Override
        public void openScreen(CardGame<?> game, class_2338 pos, CardDeck deck) {
            class_3222 serverPlayer = (class_3222)ServerPlayerMixin.this;
            game.openScreen(serverPlayer, serverPlayer.method_51469(), pos, deck);
        }

        @Override
        public void sendMessage(class_2561 message) {
            class_3222 serverPlayer = (class_3222)ServerPlayerMixin.this;
            serverPlayer.method_7353(message, false);
        }

        @Override
        public void sendTitle(class_2561 title, @Nullable class_2561 subtitle) {
            class_3222 serverPlayer = (class_3222)ServerPlayerMixin.this;
            if (subtitle != null) {
                serverPlayer.field_13987.method_14364((class_2596)new class_5903(subtitle));
            }
            serverPlayer.field_13987.method_14364((class_2596)new class_5904(title));
        }

        @Override
        public class_2561 getName() {
            class_3222 serverPlayer = (class_3222)ServerPlayerMixin.this;
            return serverPlayer.method_5476();
        }

        @Override
        public class_1767 getColor() {
            return class_1767.field_7952;
        }

        @Override
        public int getId() {
            class_3222 serverPlayer = (class_3222)ServerPlayerMixin.this;
            return serverPlayer.method_5628();
        }

        @Override
        public class_1309 getEntity() {
            return ServerPlayerMixin.this;
        }
    };

    public ServerPlayerMixin(class_1937 level, class_2338 pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @Override
    public CardPlayer charta_getCardPlayer() {
        return this.charta_cardPlayer;
    }
}

